-- new script file

local waveOff = {}
local player = {}

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
      
    if not self.loaded then
      self.active = false
      self.wave = 0
      self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
    end
		
		player = Citadels.GetPlayer(1)
    self.attackPoint = Game:GetEntity('castleC'):GetPosition()
  end
  
  if self.active then
    InitializeWave(self)
    AttackWave(self)
    self.active = false
  end  
end

function InitializeWave(self)
	if self.wave == 1 then
		waveOff['unit_L_archer_L1'] = self.baseCount * 0.17
		waveOff['unit_L_fman_L1'] = self.baseCount * 0.13
		waveOff['unit_L_rider_L1'] = self.baseCount * 0.08
		waveOff['unit_L_catapult_L2'] = self.baseCount * 0.02
		self.spawnPos = Game:GetEntity('spawnPos-1'):GetPosition()
	elseif self.wave == 2 then
		waveOff['unit_L_archer_L1'] = self.baseCount * 0.12
		waveOff['unit_L_archer_L2'] = self.baseCount * 0.08
		waveOff['unit_L_fman_L2'] = self.baseCount * 0.09
		waveOff['unit_L_rider_L1'] = self.baseCount * 0.07
		waveOff['unit_L_catapult_L1'] = self.baseCount * 0.04
		self.spawnPos = Game:GetEntity('spawnPos-2'):GetPosition()
	else
		Debug:Log("Attack failed to initialize")
		return
	end
end

function AttackWave(self)
  for prefab,ammount in pairs(waveOff) do
    player:AttackGroupAdd(prefab, ammount)
  end
  player:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  player:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  player:AttackGroupAddWayPoints(self.attackPoint)
  player:AttackGroupCommit(1, self.spawnPos, 20)
	for k, v in pairs(waveOff) do
		waveOff[k] = nil
	end
end

function OnTrigger(self, source, target)
	Debug:Log("Source = " .. source .. " !!! Target = " .. target)
  if target == "attOff1" then
    self.wave = 1
  elseif target == "attOff2" then
    self.wave = 2
  end
  self.active = true
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  self.loaded = true
	  self.active = ar:Read()
    self.wave = ar:Read()
    self.baseCount = ar:Read()
  elseif (ar:IsSaving()) then
	  ar:Write(self.active)
    ar:Write(self.wave)
    ar:Write(self.baseCount)
  end  
end

function CreateTriggerTargets(self)
	self:AddTriggerTarget("attOff1")
  self:AddTriggerTarget("attOff2")
end